﻿textMove = 0.38; //縦組みと横組みの位置を調整する係数

selObj = activeDocument.selection;
selObjCount = selObj.length;


if(selObjCount == 1){

    if(selObj[0].typename == "GroupItem") {
    
        selObj[0].pathItems[0].rotate(90);
        
        textFrame = selObj[0].textFrames[0]
        textOri = textFrame.orientation;
        textKind = textFrame.kind;

    }
    else
    {
        textFrame = selObj[0];
        textOri = selObj[0].orientation;
        textKind = selObj[0].kind;
        
    }

    textLinCunt = textFrame.lines.length;
    var textScall = [];
    
    if(textLinCunt == 1){　//一行テキストの場合
        textPara = textFrame.paragraphs[0];
        textJust = textPara.justification;
        textSize = textPara.size;
        textScall [0]= textPara.scaling;
        
        swap(textScall [0],0)
        textPara.scaling = textScall [0];

        if(textKind == "TextType.POINTTEXT" && textJust =="Justification.CENTER") {
            //一行中央揃えテキスト　縦組みと横組みの位置調整
            switch(textOri){
                case TextOrientation.HORIZONTAL : 
                textFrame.translate(0 , textSize * textMove) ;
                break;
            
                case TextOrientation.VERTICAL :
                    textFrame.translate(0 ,- textSize * textMove) ;
                break;
            }
        }
    }

    else{ //複数行テキストの場合
        for(i=0; i<textLinCunt; i++){
            textPara = textFrame.paragraphs[i];
            textScall [i]= textPara.scaling;
            
            swap(textScall [i],i)
            textPara.scaling = textScall [i];
        }
    }
    
    
    //縦組み・横組み　入れ替え
    switch(textOri){
        case TextOrientation.HORIZONTAL : 
            textFrame.orientation = TextOrientation.VERTICAL;
        break;
    
        case TextOrientation.VERTICAL :
            textFrame.orientation = TextOrientation.HORIZONTAL;
        break;
    }

}



function swap(a,n){
    sw = a[n,0];
    a[n,0] = a[n,1];
    a[n,1] = sw;
   return;
}